<?php
//------------------------------------------------------------------------------
// Jonatan Alvarsson :: MySQL Wrapper 1.2 (använder mysqli: MySQL Improved Extension)
//------------------------------------------------------------------------------
// Innehåller även funktionerna clean(), clean_email(), clean_to_html(), to_html()
// Kräver följande variabler: $cfg->mysql_host, $cfg->mysql_user, $cfg->mysql_passwd, $cfg->mysql_db
//------------------------------------------------------------------------------

$db_link = mysqli_connect($cfg->mysql_host, $cfg->mysql_user, $cfg->mysql_passwd, $cfg->mysql_db);
if (!$db_link)
{
	//echo '<pre>' . mysqli_connect_error() . '</pre>';
	die('Unable to connect to MySQL server');
}
mysqli_query($db_link, 'SET NAMES UTF8');



//------------------------------------------------------------------------------
// wrapper för mysqli_query()
//------------------------------------------------------------------------------
function query($sql)
{
	global $db_link;

	$result = mysqli_query($db_link, $sql) or die('<b>Invalid MySQL query:</b> ' . mysqli_errno($db_link) . ': ' . mysqli_error($db_link) . '<br /><pre>' . $sql . '</pre>');

	return $result;
}



//------------------------------------------------------------------------------
// wrapper för mysqli_fetch_array()
//
// $rows = true			alla rader, $array[0]['field']
// $rows = false		bara första raden, $array['field']
// $result_type			kan vara MYSQLI_ASSOC, MYSQLI_NUM eller MYSQLI_BOTH
//------------------------------------------------------------------------------
function result($result, $rows = true, $result_type = MYSQLI_ASSOC)
{
	$array = array();
	while ($info = mysqli_fetch_array($result, $result_type))
	{
		$array[] = $info;
	}
	if ( $rows == false && isset($array[0]) )
	{
		$array = $array[0];
	}
	
	return $array;
}



//------------------------------------------------------------------------------
// Rensar en sträng och förbereder den för MySQL-queries
//------------------------------------------------------------------------------
function clean($string, $stripslashes_flag = true)
{
	global $db_link;

  //rensar alla HTML- och PHP-koder från strängen
	$string = strip_tags($string);
  
  //tar bort < > |
  $string = str_replace('|', '', $string);
	$string = str_replace('<', '', $string);
  $string = str_replace('>', '', $string);
	
	//omvandlar radbrytningar \n \r och tabbar \t till mellanslag
	$string = str_replace("\n", " ", $string);
	$string = str_replace("\r", " ", $string);
	$string = str_replace("\t", " ", $string);
	
	//tar bort alla mellanslag i början och i slutet av strängen
	$string = trim($string);
	
	if ( $stripslashes_flag )
	{
		//reverse magic_quotes_gpc/magic_quotes_sybase effects on those vars if ON
	  if ( get_magic_quotes_gpc() )
		{
			$string = stripslashes($string);
	  }
	}
	
	//escapar strängen för användning i databasen
	$string = mysqli_real_escape_string($db_link, $string);
	
  return ( $string !== '' ) ? $string : NULL;
}



//------------------------------------------------------------------------------
// Rensar en sträng och förbereder den för E-postutskick
//------------------------------------------------------------------------------
function clean_email($string, $stripslashes_flag = true)
{
  //rensar alla HTML- och PHP-koder från strängen
	$string = strip_tags($string);
  
	//tar bort alla mellanslag i början och i slutet av strängen
	$string = trim($string);
	
	if ( $stripslashes_flag )
	{
		//reverse magic_quotes_gpc/magic_quotes_sybase effects on those vars if ON
	  if ( get_magic_quotes_gpc() )
		{
			$string = stripslashes($string);
	  }
	}

  return $string;
}



//------------------------------------------------------------------------------
// Tar en sträng (från formulär) (som rensats med clean) och förbereder den för HTML-output 
//------------------------------------------------------------------------------
function clean_to_html($string, $stripslashes_flag = true)
{
	//konverterar specialtecken:   & " ' < >   till motsvarande html-koder:   &amp; &quot; &#039; &lt; &gt;
	$string = htmlspecialchars($string, ENT_QUOTES);
	
	if ( $stripslashes_flag )
	{
		$string = stripslashes($string);
	}
	
  return $string;
}



//------------------------------------------------------------------------------
// Tar en sträng (från db) och förbereder den för HTML-output 
//------------------------------------------------------------------------------
function to_html($string)
{
	//konverterar specialtecken:   & " ' < >   till motsvarande html-koder:   &amp; &quot; &#039; &lt; &gt;
	$string = htmlspecialchars($string, ENT_QUOTES);
	
  return $string;
}

?>